#include <bits/stdc++.h>
using namespace std;
using int64 = long long;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int N;
    if(!(cin >> N)) return 0;
    vector<int64> x(N), y(N);
    for (int i = 0; i < N; ++i) cin >> x[i] >> y[i];

    unordered_map<int64, pair<int64,int64>> row;
    unordered_map<int64, pair<int64,int64>> col;
    unordered_map<int64, int64> diag1;
    unordered_map<int64, int64> diag2;

    row.reserve(N*2);
    col.reserve(N*2);
    diag1.reserve(N*2);
    diag2.reserve(N*2);

    for (int i = 0; i < N; ++i) {
        int64 xi = x[i], yi = y[i];
        int64 px = ( (xi & 1) == 0 ? 0 : 1 );
        int64 py = ( (yi & 1) == 0 ? 0 : 1 );

        auto &r = row[yi];
        if (px == 0) r.first++; else r.second++;

        auto &c = col[xi];
        if (py == 0) c.first++; else c.second++;

        diag1[xi - yi] += 1;
        diag2[xi + yi] += 1;
    }

    auto comb2 = [](int64 k)->int64 {
        return k < 2 ? 0 : (k*(k-1))/2;
    };

    long long ans = 0;

    for (auto &kv : row) {
        ans += comb2(kv.second.first);
        ans += comb2(kv.second.second);
    }

    for (auto &kv : col) {
        ans += comb2(kv.second.first);
        ans += comb2(kv.second.second);
    }

    for (auto &kv : diag1) {
        ans += 2 * comb2(kv.second);
    }

    for (auto &kv : diag2) {
        ans += 2 * comb2(kv.second);
    }

    cout << ans << "\n";
    return 0;
}